<?php
session_start();
require_once '../config/database.php';
require_once '../includes/functions.php';

requireAdmin();

// Get dashboard stats
$stats = [
    'malls' => $pdo->query("SELECT COUNT(*) FROM malls WHERE status = 'active'")->fetchColumn(),
    'stores' => $pdo->query("SELECT COUNT(*) FROM stores WHERE status = 'active'")->fetchColumn(),
    'movies' => $pdo->query("SELECT COUNT(*) FROM movies WHERE status = 'now_showing'")->fetchColumn(),
    'news' => $pdo->query("SELECT COUNT(*) FROM news_events WHERE status = 'published'")->fetchColumn(),
    'subscribers' => $pdo->query("SELECT COUNT(*) FROM newsletter_subscriptions WHERE status = 'active'")->fetchColumn(),
    'community_cards' => $pdo->query("SELECT COUNT(*) FROM community_cards WHERE status = 'active'")->fetchColumn()
];

// Get recent activities
$recent_news = $pdo->query("SELECT * FROM news_events ORDER BY created_at DESC LIMIT 5")->fetchAll();
$recent_subscribers = $pdo->query("SELECT * FROM newsletter_subscriptions ORDER BY subscribed_at DESC LIMIT 5")->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Ortigas Malls</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="assets/css/admin.css">
</head>
<body class="admin-body">
    <div class="admin-container">
        <!-- Sidebar -->
        <aside class="admin-sidebar">
            <div class="admin-logo">
                <h2>Ortigas Admin</h2>
            </div>
            <nav class="admin-nav">
                <ul>
                    <li><a href="index.php" class="active">Dashboard</a></li>
                    <li><a href="malls.php">Malls</a></li>
                    <li><a href="stores.php">Stores</a></li>
                    <li><a href="movies.php">Movies</a></li>
                    <li><a href="news.php">News & Events</a></li>
                    <li><a href="community-cards.php">Community Cards</a></li>
                    <li><a href="subscribers.php">Newsletter</a></li>
                    <li><a href="logout.php">Logout</a></li>
                </ul>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="admin-main">
            <header class="admin-header">
                <h1>Dashboard</h1>
                <div class="admin-user">
                    Welcome, <?= htmlspecialchars($_SESSION['admin_username'] ?? 'Admin') ?>
                </div>
            </header>

            <!-- Stats Cards -->
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-icon">🏬</div>
                    <div class="stat-content">
                        <h3><?= $stats['malls'] ?></h3>
                        <p>Active Malls</p>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-icon">🏪</div>
                    <div class="stat-content">
                        <h3><?= $stats['stores'] ?></h3>
                        <p>Active Stores</p>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-icon">🎬</div>
                    <div class="stat-content">
                        <h3><?= $stats['movies'] ?></h3>
                        <p>Now Showing</p>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-icon">📰</div>
                    <div class="stat-content">
                        <h3><?= $stats['news'] ?></h3>
                        <p>Published News</p>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-icon">📧</div>
                    <div class="stat-content">
                        <h3><?= $stats['subscribers'] ?></h3>
                        <p>Subscribers</p>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-icon">🎫</div>
                    <div class="stat-content">
                        <h3><?= $stats['community_cards'] ?></h3>
                        <p>Community Cards</p>
                    </div>
                </div>
            </div>

            <!-- Content Grid -->
            <div class="content-grid">
                <!-- Recent News -->
                <div class="content-card">
                    <div class="card-header">
                        <h3>Recent News & Events</h3>
                        <a href="news.php" class="btn-link">View All</a>
                    </div>
                    <div class="card-content">
                        <?php if (empty($recent_news)): ?>
                            <p class="no-data">No recent news found.</p>
                        <?php else: ?>
                            <div class="list-items">
                                <?php foreach ($recent_news as $news): ?>
                                <div class="list-item">
                                    <div class="item-content">
                                        <h4><?= htmlspecialchars($news['title']) ?></h4>
                                        <p class="item-meta">
                                            <span class="badge badge-<?= $news['type'] ?>"><?= ucfirst($news['type']) ?></span>
                                            <span class="item-date"><?= formatDate($news['created_at']) ?></span>
                                        </p>
                                    </div>
                                    <div class="item-status">
                                        <span class="status-<?= $news['status'] ?>"><?= ucfirst($news['status']) ?></span>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Recent Subscribers -->
                <div class="content-card">
                    <div class="card-header">
                        <h3>Recent Newsletter Subscribers</h3>
                        <a href="subscribers.php" class="btn-link">View All</a>
                    </div>
                    <div class="card-content">
                        <?php if (empty($recent_subscribers)): ?>
                            <p class="no-data">No recent subscribers found.</p>
                        <?php else: ?>
                            <div class="list-items">
                                <?php foreach ($recent_subscribers as $subscriber): ?>
                                <div class="list-item">
                                    <div class="item-content">
                                        <h4><?= htmlspecialchars($subscriber['email']) ?></h4>
                                        <p class="item-meta">
                                            <span class="item-date"><?= formatDateTime($subscriber['subscribed_at']) ?></span>
                                        </p>
                                    </div>
                                    <div class="item-status">
                                        <span class="status-<?= $subscriber['status'] ?>"><?= ucfirst($subscriber['status']) ?></span>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="quick-actions">
                <h3>Quick Actions</h3>
                <div class="action-buttons">
                    <a href="news.php?action=add" class="btn btn-primary">Add News/Event</a>
                    <a href="stores.php?action=add" class="btn btn-secondary">Add Store</a>
                    <a href="movies.php?action=add" class="btn btn-secondary">Add Movie</a>
                    <a href="../index.php" class="btn btn-outline" target="_blank">View Website</a>
                </div>
            </div>
        </main>
    </div>

    <script src="../assets/js/main.js"></script>
    <script src="assets/js/admin.js"></script>
</body>
</html>
