-- Create database
CREATE DATABASE IF NOT EXISTS ortigas_malls;
USE ortigas_malls;

-- Malls table
CREATE TABLE malls (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    slug VARCHAR(255) UNIQUE NOT NULL,
    tagline VARCHAR(500),
    description TEXT,
    image VARCHAR(500),
    status ENUM('active', 'inactive') DEFAULT 'active',
    display_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Stores table
CREATE TABLE stores (
    id INT AUTO_INCREMENT PRIMARY KEY,
    mall_id INT,
    name VARCHAR(255) NOT NULL,
    category VARCHAR(100),
    floor VARCHAR(50),
    description TEXT,
    logo VARCHAR(500),
    featured BOOLEAN DEFAULT FALSE,
    status ENUM('active', 'inactive') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (mall_id) REFERENCES malls(id) ON DELETE CASCADE
);

-- Movies table
CREATE TABLE movies (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    rating VARCHAR(20),
    duration VARCHAR(50),
    description TEXT,
    image VARCHAR(500),
    cinema_location VARCHAR(255),
    status ENUM('now_showing', 'coming_soon', 'ended') DEFAULT 'now_showing',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- News/Events table
CREATE TABLE news_events (
    id INT AUTO_INCREMENT PRIMARY KEY,
    mall_id INT,
    type ENUM('news', 'event', 'promo') NOT NULL,
    title VARCHAR(255) NOT NULL,
    content TEXT,
    image VARCHAR(500),
    status ENUM('published', 'draft') DEFAULT 'draft',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (mall_id) REFERENCES malls(id) ON DELETE SET NULL
);

-- Community Cards table
CREATE TABLE community_cards (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_name VARCHAR(255) NOT NULL,
    email VARCHAR(255) UNIQUE NOT NULL,
    phone VARCHAR(20),
    card_number VARCHAR(50) UNIQUE NOT NULL,
    status ENUM('active', 'inactive') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Newsletter subscriptions table
CREATE TABLE newsletter_subscriptions (
    id INT AUTO_INCREMENT PRIMARY KEY,
    email VARCHAR(255) UNIQUE NOT NULL,
    status ENUM('active', 'unsubscribed') DEFAULT 'active',
    subscribed_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Admin users table
CREATE TABLE admin_users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(100) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    email VARCHAR(255) UNIQUE NOT NULL,
    status ENUM('active', 'inactive') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Insert sample malls data
INSERT INTO malls (name, slug, tagline, description, image, display_order) VALUES
('Greenhills', 'greenhills', 'ULTIMATE SHOPPING EXPERIENCE', 'Experience the ultimate shopping destination with a wide variety of stores, dining options, and entertainment facilities.', 'https://ext.same-assets.com/3316781251/2057618522.png', 1),
('Estancia', 'estancia', 'Live your Life in Style', 'A premium lifestyle destination offering luxury shopping, fine dining, and sophisticated entertainment.', 'https://ext.same-assets.com/3316781251/3680459388.png', 2),
('Tiendesitas', 'tiendesitas', 'World of Offerings and Flavors', 'Discover a world of unique local products, authentic Filipino cuisine, and cultural experiences.', 'https://ext.same-assets.com/3316781251/948184881.png', 3),
('The Strip', 'the-strip', 'Come out and Let\'s play', 'An outdoor lifestyle center perfect for entertainment, dining, and leisure activities.', 'https://ext.same-assets.com/3316781251/2556514089.png', 4);

-- Insert sample movies data
INSERT INTO movies (title, rating, duration, description, image, cinema_location, status) VALUES
('Mission: Impossible - The Final Reckoning', 'PG-13', '02 hrs, 50 mins', 'Our lives are the sum of our choices. Tom Cruise is Ethan Hunt in Mission: Impossible - The Final Reckoning.', 'https://ext.same-assets.com/3316781251/3730565509.jpeg', 'Estancia', 'now_showing'),
('Mission: Impossible - The Final Reckoning', 'PG-13', '02 hrs, 50 mins', 'Our lives are the sum of our choices. Tom Cruise is Ethan Hunt in Mission: Impossible - The Final Reckoning.', 'https://ext.same-assets.com/3316781251/3730565509.jpeg', 'Promenade', 'now_showing'),
('Mission: Impossible - The Final Reckoning', 'PG-13', '02 hrs, 50 mins', 'Our lives are the sum of our choices. Tom Cruise is Ethan Hunt in Mission: Impossible - The Final Reckoning.', 'https://ext.same-assets.com/3316781251/3730565509.jpeg', 'GH Mall', 'now_showing');

-- Insert sample news/events data
INSERT INTO news_events (mall_id, type, title, content, status) VALUES
(2, 'news', 'Divine Mercy Chapel', 'New chapel opens at Estancia Mall for the spiritual needs of our community.', 'published'),
(2, 'event', '3 Day Fab Sale', 'The biggest sale event of the year with up to 70% off on selected items across all participating stores.', 'published'),
(2, 'promo', 'Ebi10', 'Special dining promotion featuring Japanese cuisine with exclusive discounts and offers.', 'published');

-- Insert sample stores data
INSERT INTO stores (mall_id, name, category, floor, description, logo, featured) VALUES
(1, 'Kultura', 'Lifestyle', '2F', 'Filipino-inspired lifestyle and home products store.', 'https://ext.same-assets.com/3316781251/2057618522.png', TRUE),
(1, 'Evernew', 'Department Store', 'GF, Main Mall', 'Complete department store with fashion, electronics, and household items.', 'https://ext.same-assets.com/3316781251/3680459388.png', TRUE),
(3, 'Decathlon', 'Sports', 'BLDG. C LEVEL 2', 'Sports equipment and activewear for all your fitness needs.', 'https://ext.same-assets.com/3316781251/948184881.png', TRUE),
(4, 'Taylors Play Café', 'Dining', 'GF', 'Family-friendly café with play area for children and delicious meals.', 'https://ext.same-assets.com/3316781251/2556514089.png', TRUE);

-- Create admin user (password: admin123)
INSERT INTO admin_users (username, password, email) VALUES
('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin@ortigasmalls.com');
