<?php
require_once 'config/database.php';
require_once 'includes/functions.php';

// Get featured malls
$malls = getMalls($pdo);
$featured_movies = getFeaturedMovies($pdo, 3);
$recent_news = getRecentNews($pdo, 3);
$featured_stores = getFeaturedStores($pdo, 4);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ortigas Malls - Larger Than Life</title>
    <meta name="description" content="Experience Ortigas at its finest with Ortigas Malls – where luxury, discovery, innovation, and Filipino culture unite across four unique destinations.">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <!-- Header -->
    <header class="main-header">
        <nav class="navbar">
            <div class="nav-container">
                <div class="nav-left">
                    <a href="index.php" class="logo">
                        <img src="assets/images/ortigas-logo.svg" alt="Ortigas Malls">
                    </a>
                </div>

                <div class="nav-center">
                    <ul class="nav-menu">
                        <li><a href="mall-directory.php">Mall Directory</a></li>
                        <li><a href="whats-new.php">What's New</a></li>
                        <li><a href="community-card.php">Community Card</a></li>
                    </ul>
                </div>

                <div class="nav-right">
                    <a href="search.php" class="search-btn">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                            <path d="M21 21L16.514 16.506M19 10.5C19 15.194 15.194 19 10.5 19S2 15.194 2 10.5 5.806 2 10.5 2 19 5.806 19 10.5Z" stroke="currentColor" stroke-width="2"/>
                        </svg>
                    </a>
                    <button class="mobile-menu-btn">
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>
                </div>
            </div>
        </nav>

        <!-- Mobile Menu -->
        <div class="mobile-menu">
            <div class="mobile-menu-links">
                <a href="greenhills.php">Greenhills</a>
                <a href="estancia.php">Estancia</a>
                <a href="tiendesitas.php">Tiendesitas</a>
                <a href="the-strip.php">The Strip</a>
                <a href="community-card.php">Community Card</a>
                <a href="whats-new.php">What's New</a>
                <a href="leasing.php">Leasing</a>
                <a href="about.php">About Us</a>
                <a href="contact.php">Contact Us</a>
            </div>
        </div>
    </header>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="hero-content">
            <div class="hero-text">
                <h1 class="hero-title">Larger Than Life</h1>
                <p class="hero-description">
                    Indulge in Larger Than Life moments and get ready for bigger and bolder memories in every corner!
                    Our malls will redefine your experience and elevate it to something extraordinary.
                    From heart-pumping shopping selections to eye-popping shows and entertainment, experience them all here.
                </p>
                <a href="mall-directory.php" class="btn-primary">Explore Malls</a>
            </div>
        </div>
        <div class="hero-bg">
            <img src="https://ext.same-assets.com/3316781251/1420797492.webp" alt="Ortigas Malls">
        </div>
    </section>

    <!-- Cinema Section -->
    <section class="cinema-section">
        <div class="container">
            <div class="section-header">
                <h2>Experience Ortigas Cinemas</h2>
                <p>See movies like never before here at Ortigas Cinemas. Whether you're out with family, on a date with someone special, or just another Friday with your constants, our screens can surely make your movie date a day to remember.</p>
                <a href="cinemas.php" class="btn-secondary">Book Tickets</a>
            </div>
        </div>
    </section>

    <!-- Fab Sale Promo -->
    <section class="promo-section">
        <div class="container">
            <div class="promo-content">
                <h2>3 Day Fab Sale</h2>
                <p>The 3-Day Fab Sale is back – and this year, it's bigger, better, and bolder than ever before!</p>
                <a href="whats-new.php" class="btn-primary">Shop Now</a>
            </div>
        </div>
    </section>

    <!-- Malls Section -->
    <section class="malls-section">
        <div class="container">
            <div class="malls-grid">
                <?php foreach ($malls as $mall): ?>
                <div class="mall-card">
                    <div class="mall-image">
                        <img src="<?= htmlspecialchars($mall['image']) ?>" alt="<?= htmlspecialchars($mall['name']) ?>">
                    </div>
                    <div class="mall-content">
                        <h3><?= htmlspecialchars($mall['name']) ?></h3>
                        <p><?= htmlspecialchars($mall['tagline']) ?></p>
                        <a href="mall.php?slug=<?= htmlspecialchars($mall['slug']) ?>" class="mall-link">Explore</a>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Community Card Section -->
    <section class="community-card-section">
        <div class="container">
            <div class="community-card-content">
                <div class="card-text">
                    <h2>Exploring a world of perks and privileges with Ortigas Community Card</h2>
                    <div class="crown-icon">
                        <img src="https://ext.same-assets.com/3316781251/1816826136.svg" alt="Crown">
                    </div>
                    <p>Be part of an exclusive club, enjoy markdowns and rebates, and get invited to Ortigas Community Card-exclusive events, all in just a few clicks!</p>
                    <div class="card-features">
                        <span class="feature-badge">Free!</span>
                        <span class="feature-text">Exclusive Events, Promos, Discounts, and many more</span>
                    </div>
                    <div class="app-downloads">
                        <a href="#" class="app-store">
                            <img src="https://ext.same-assets.com/3316781251/4232729720.svg" alt="Download on App Store">
                        </a>
                        <a href="#" class="google-play">
                            <img src="https://ext.same-assets.com/3316781251/2205231785.svg" alt="Get it on Google Play">
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Now Showing Movies -->
    <section class="movies-section">
        <div class="container">
            <div class="section-header">
                <h2>Now Showing</h2>
                <p>Experience the best, the acclaimed, and the blockbusters only here at Ortigas Cinemas.</p>
            </div>
            <div class="movies-grid">
                <?php foreach ($featured_movies as $movie): ?>
                <div class="movie-card">
                    <div class="movie-image">
                        <img src="<?= htmlspecialchars($movie['image']) ?>" alt="<?= htmlspecialchars($movie['title']) ?>">
                    </div>
                    <div class="movie-content">
                        <div class="movie-status">Now Showing</div>
                        <div class="movie-cinema"><?= htmlspecialchars($movie['cinema_location']) ?></div>
                        <h3><?= htmlspecialchars($movie['title']) ?></h3>
                        <div class="movie-meta">
                            <span class="rating"><?= htmlspecialchars($movie['rating']) ?></span>
                            <span class="duration"><?= htmlspecialchars($movie['duration']) ?></span>
                        </div>
                        <p><?= htmlspecialchars($movie['description']) ?></p>
                        <a href="movie.php?id=<?= $movie['id'] ?>" class="btn-primary">Book Tickets</a>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- What's Happening -->
    <section class="whats-happening-section">
        <div class="container">
            <div class="section-header">
                <h2>What's Happening</h2>
            </div>
            <div class="news-grid">
                <?php foreach ($recent_news as $news): ?>
                <div class="news-card">
                    <div class="news-type"><?= htmlspecialchars($news['type']) ?></div>
                    <h3><?= htmlspecialchars($news['title']) ?></h3>
                    <div class="news-location"><?= htmlspecialchars($news['mall_name']) ?></div>
                    <a href="news.php?id=<?= $news['id'] ?>" class="news-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none">
                            <path d="M9 18L15 12L9 6" stroke="currentColor" stroke-width="2"/>
                        </svg>
                    </a>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Fresh Features -->
    <section class="fresh-features-section">
        <div class="container">
            <div class="section-header">
                <h2>Fresh Features: Discover our latest shops and dining experiences!</h2>
                <div class="feature-tabs">
                    <button class="tab-btn active" data-tab="shops">Shops</button>
                    <button class="tab-btn" data-tab="dining">Dining</button>
                </div>
            </div>
            <div class="stores-grid">
                <?php foreach ($featured_stores as $store): ?>
                <div class="store-card">
                    <div class="store-logo">
                        <img src="<?= htmlspecialchars($store['logo']) ?>" alt="<?= htmlspecialchars($store['name']) ?>">
                    </div>
                    <div class="store-content">
                        <h3><?= htmlspecialchars($store['name']) ?></h3>
                        <div class="store-location">
                            <svg width="12" height="12" viewBox="0 0 24 24" fill="none">
                                <path d="M21 10C21 17L12 23L3 17C3 10 7.58 4 12 4S21 10 21 10Z" stroke="currentColor" stroke-width="2"/>
                            </svg>
                            <?= htmlspecialchars($store['location']) ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Newsletter Section -->
    <section class="newsletter-section">
        <div class="container">
            <div class="newsletter-content">
                <div class="newsletter-text">
                    <h2>Stay Vibin', Stay Informed</h2>
                    <p>This is your front row seat to Ortigas Malls!</p>
                    <p>Stay in the loop. Get the deets on our latest news and events sent straight to your inbox. Be the trendsetter among your squad – sign up now!</p>
                </div>
                <form class="newsletter-form" action="subscribe.php" method="POST">
                    <input type="email" name="email" placeholder="Enter your email" required>
                    <button type="submit" class="btn-primary">Subscribe to Newsletter</button>
                </form>
            </div>
            <div class="newsletter-image">
                <img src="https://ext.same-assets.com/3316781251/3361527382.webp" alt="Newsletter">
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="main-footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h3>Quick Links</h3>
                    <ul>
                        <li><a href="greenhills.php">Greenhills</a></li>
                        <li><a href="estancia.php">Estancia</a></li>
                        <li><a href="tiendesitas.php">Tiendesitas</a></li>
                        <li><a href="the-strip.php">The Strip</a></li>
                        <li><a href="mall-directory.php">Mall Directory</a></li>
                        <li><a href="community-card.php">Community Card</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h3>Information</h3>
                    <ul>
                        <li><a href="whats-new.php">What's New</a></li>
                        <li><a href="leasing.php">Leasing</a></li>
                        <li><a href="about.php">About Us</a></li>
                        <li><a href="contact.php">Contact Us</a></li>
                        <li><a href="media-center.php">Media Center</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h3>Community Card</h3>
                    <p>Exploring a world of perks and privileges with Ortigas Community Card</p>
                    <p>Avail of exclusive discounts, and participate in Community Card-exclusive events with only a few clicks!</p>
                    <div class="app-downloads">
                        <a href="#" class="app-store">
                            <img src="https://ext.same-assets.com/3316781251/4232729720.svg" alt="App Store">
                        </a>
                        <a href="#" class="google-play">
                            <img src="https://ext.same-assets.com/3316781251/2205231785.svg" alt="Google Play">
                        </a>
                    </div>
                </div>
                <div class="footer-section">
                    <h3>Newsletter</h3>
                    <p>Want to learn more about Ortigas Malls?</p>
                    <p>Sign up to receive more information about our news and events via email!</p>
                    <form class="footer-newsletter" action="subscribe.php" method="POST">
                        <input type="email" name="email" placeholder="Enter email" required>
                        <button type="submit">Subscribe</button>
                    </form>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; 2024 Ortigas Malls. All rights reserved.</p>
                <div class="footer-links">
                    <a href="terms.php">Terms of Use</a>
                    <a href="privacy.php">Privacy Policy</a>
                </div>
            </div>
        </div>
    </footer>

    <script src="assets/js/main.js"></script>
</body>
</html>
